* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

**********************************************************************
**********************************************************************
* 					TFP estimation a la OP
**********************************************************************
**********************************************************************
* Following Imrohoroglu and Tuzel (2014)

rename gdp_ind gdp_def
rename wage_ind wages
rename nonres_ind inv_def

* Compute value added
gen total_expense 	= sale - oibdp
gen labor_expense  	= emp * wage
gen materials 		= total_expense - labor_expense
gen value_added		= sale-materials

* Compute the age of capital
gen cap_age 		= dpact / dp
gen ave_age 		= cap_age
replace ave_age 	= ( cap_age[_n-1] + cap_age[_n] )/2 if fyear==fyear[_n-1]+1
replace ave_age 	= ( cap_age[_n-2] + cap_age[_n-1] + cap_age[_n] )/3 if fyear==fyear[_n-1]+1 & fyear==fyear[_n-2]+2
gen age 			= round(ave_age,1) 
gen cap_year 		= fyear-age
replace cap_year    = 1951 if cap_year<1951 

* Match PPE with the investment price deflator from year cap_year
rename fyear year
rename cap_year fyear
merge m:1 fyear using "$datapath/prices_updated.dta", keep(match)
drop _merge gdp_ind wage_ind
rename fyear cap_year
rename year fyear
rename nonres_ind past_inv_def

* compute the "quantities" of output, investment, and capital
* use GDP and investment price deflators
sort gvkey fyear
gen adj_value  		= value_added / gdp_def
gen adj_cap  		= ppegt / past_inv_def
gen adj_inv 		= capx / inv_def

by gvkey: gen lag_cap = adj_cap[_n-1] if fyear==fyear[_n-1]+1

* additional filters for correct calculation of value added
drop if materials<0.01
drop if adj_value<0.01

* Cleaning
drop dp dpact oibdp wages total_expense labor_expense
drop materials cap_age ave_age age cap_year adj_cap 
drop past_inv_def year1 

* For TFP estimation
rename fyear year
rename adj_inv i
gen l = emp
rename adj_value y
rename lag_cap k

* Create logs
replace y  			= log(y)
replace i  			= log(i)
replace l  			= log(l)
replace k  			= log(k)

drop if k==. | y==. | l==.

xtset id year
order id year sic y l k i

set matsize 11000

* * generate 3-digit SIC codes
gen SIC = sic 
destring sic, replace
replace sic=floor(sic/10) 

sum year
return list
scalar last=r(max)

*define exit
gen exit = 0
replace exit=1 if year==year2& year!=last

*********
* Get the first year of exit from Compustat
* Note that there are no exits from Compustat before 1967
sum year2
return list
scalar firstexit=r(min)
********;
drop year2
drop if year<firstexit

gen i2=i^2
gen k2=k^2
gen ik=i*k

order id year sic y l k i i2 k2 ik
gen ind_year=year*1000+sic

* These are the factor elasticities
gen capital=0
gen labor=0

sum year
return list
scalar min=r(min)+1 
scalar max=r(max)
scalar size=max-min+1

matrix betas=J(2,size,0)

scalar col=0
gen TFP=.

drop SIC 

***************************************************************
* Estimation
***************************************************************


* expanding window production function estimation
forvalues q=`=min'/`=max'{

	disp "`q'"
	* generate exit probabilities
	if `q'>`=firstexit' {
		qui probit exit i k ik i2 k2 if year <=`q' 
		qui predict exit_prob if year <=`q' 
	} 
	else {
		qui gen exit_prob = 0 
	}
	   
	* first stage regression, estimate labor coef.
	qui areg y l k i i2 k2 ik  if year <=`q', absorb(ind_year)

	qui predict res, residuals
	ereturn list
	matrix betas_1=e(b)
	scalar col=col+1
	matrix betas[1,col]=betas_1[1,1]
	replace labor=betas_1[1,1] if year==`q'
	
	* second stage regression to estimate the coef. for capital
	gen Q= _b[i]*i + _b[k]*k + _b[i2]*i2 + _b[k2]*k2 + _b[ik]*ik 
	gen y_al= Q + res
	qui nl (y_al = {b_0=0} + {b_1=0.3}*k + {b_2=0.5}*(L.Q - {b_1=0.3}*L.k)+{b_exit=0}*L.exit_prob) if year <=`q' & !missing(L.k) & !missing(L.exit_prob)

	ereturn list
	matrix betas_2=e(b)
	matrix betas[2,col]=betas_2[1,2]
	replace capital=betas_2[1,2] if year==`q'
	
	* compute TFP
	replace TFP=y_al-k*capital if TFP==.
	
	drop res Q exit_prob y_al
	
}
	
matrix b=betas'

* Production function estimates
* Coefficients for capital and labor, expanding window estimates
* matrix list b

* delete observations if there are fewer than five observations from that industry
* (due to industry specific time dummies)
bysort year sic: gen a=_N
drop if a<5
drop a


* Factor shares
gen alphahat = capital / (1-labor)
lab var alphahat "Effective capital share"

* Average capital and labor shares
egen alpha 	= mean(capital)
egen beta 	= mean(labor)

lab var TFP "TFP, firm-level (in logs)"
lab var emp "Employment, firm-level"


**********************************************************************
**********************************************************************
* 					APK variables
**********************************************************************
**********************************************************************

* The average product of capital is given by y / k. 
sort id year
gen s 	= sale / gdp_def
* gen va 	= value_added / gdp_def
local yvars s 
local kvars ppegt
foreach y of local yvars{
	foreach x of local kvars{
		gen APK_`y'_`x' 	= log(`y' / `x')
	}
}

* The main measure of APK is APK_sale_ppegt 
ren APK_s_ppegt APK
lab var APK "APK, firm-level"
